#include<stdio.h>
#include<pthread.h>
#include<stdlib.h>
#include<unistd.h>
#include<time.h>
#define brojVozila 10

enum smer{
    JUZNI,SEVERNI
};

enum smer trenutniSmer=JUZNI;

int brojAutomobila=0;
int brojAutobusa=0;
int brojKamiona=0;

int brojSevernih=0;
int brojJuznih=0;

pthread_mutex_t pristupNadvoznjaku;
pthread_cond_t uslovNadvoznjaku;

void *automobil(void *i){
    int redniBroj=(long)i;
    enum smer smer=redniBroj<brojVozila/2?JUZNI:SEVERNI; //prva polovina juzni, druga severni
    sleep(rand()%5);
    pthread_mutex_lock(&pristupNadvoznjaku);
    while(((smer==JUZNI && brojSevernih>=1)||(smer==SEVERNI && brojJuznih>=1)) || brojAutobusa>=2 || brojKamiona>=1){
        pthread_cond_wait(&uslovNadvoznjaku,&pristupNadvoznjaku);
    }
    if(smer==JUZNI) brojJuznih++;
    else brojSevernih++;
    brojAutomobila++;
    pthread_mutex_unlock(&pristupNadvoznjaku);
    printf("Automobil %d\n",smer);
    sleep(1);
    pthread_mutex_lock(&pristupNadvoznjaku);
    brojAutomobila--;
    if(smer==JUZNI) brojJuznih--;
    else brojSevernih--;
    pthread_cond_broadcast(&uslovNadvoznjaku);
    pthread_mutex_unlock(&pristupNadvoznjaku);
}

void *autobus(void *i){
    int redniBroj=(long)i;
    enum smer smer=redniBroj<brojVozila/2?JUZNI:SEVERNI;
    sleep(rand()%5);
    pthread_mutex_lock(&pristupNadvoznjaku);
    while(((smer==JUZNI && brojSevernih>=1)||(smer==SEVERNI && brojJuznih>=1)) || brojAutobusa!=0 || brojKamiona!=0){
        pthread_cond_wait(&uslovNadvoznjaku,&pristupNadvoznjaku);
    }
    if(smer==JUZNI) brojJuznih++;
    else brojSevernih++;
    brojAutobusa++;
    pthread_mutex_unlock(&pristupNadvoznjaku);
    printf("Autobus %d\n",smer);
    sleep(1);
    pthread_mutex_lock(&pristupNadvoznjaku);
    brojAutobusa--;
    if(smer==JUZNI) brojJuznih--;
    else brojSevernih--;
    pthread_cond_broadcast(&uslovNadvoznjaku);
    pthread_mutex_unlock(&pristupNadvoznjaku);
}

void *kamion(void *i){
    int redniBroj=(long)i;
    enum smer smer=redniBroj<brojVozila/2?JUZNI:SEVERNI;
    sleep(rand()%5);
    pthread_mutex_lock(&pristupNadvoznjaku);
    while(((smer==JUZNI && brojSevernih>=1)||(smer==SEVERNI && brojJuznih>=1)) || brojAutomobila!=0 || brojKamiona!=0 || brojAutobusa!=0){
        pthread_cond_wait(&uslovNadvoznjaku,&pristupNadvoznjaku);
    }
    if(smer==JUZNI) brojJuznih++;
    else brojSevernih++;
    brojKamiona++;
    pthread_mutex_unlock(&pristupNadvoznjaku);
    printf("Kamion %d\n",smer);
    sleep(1);
    pthread_mutex_lock(&pristupNadvoznjaku);
    brojKamiona--;
    if(smer==JUZNI) brojJuznih--;
    else brojSevernih--;
    pthread_cond_broadcast(&uslovNadvoznjaku);
    pthread_mutex_unlock(&pristupNadvoznjaku);
}

int main()
{
    srand(time(NULL));
    pthread_t vozila[brojVozila];
    pthread_mutex_init(&pristupNadvoznjaku,NULL);
    pthread_cond_init(&uslovNadvoznjaku,NULL);
    for(int i=0;i<brojVozila;i++){
        pthread_create(&vozila[i],NULL,i%3==0 ? automobil : (i%3==1 ? autobus : kamion),(void *)(long)i);
    }
    for(int i=0;i<brojVozila;i++){
        pthread_join(vozila[i],NULL);
    }
    pthread_mutex_destroy(&pristupNadvoznjaku);
    pthread_cond_destroy(&uslovNadvoznjaku);
    return 0;
}